package com.qboxus.tictic.activitesfragments.livestreaming.ui;

import android.content.Context;
import android.graphics.Color;
import android.os.Handler;
import android.os.Looper;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.view.SurfaceView;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.qboxus.tictic.Constants;
import com.qboxus.tictic.R;
import com.qboxus.tictic.activitesfragments.livestreaming.stats.StatsData;
import com.qboxus.tictic.activitesfragments.livestreaming.stats.StatsManager;
import com.qboxus.tictic.simpleclasses.Functions;

import java.util.ArrayList;
import java.util.List;


public class VideoGridContainer extends RelativeLayout implements Runnable {
    private static final int MAX_USER = 2;
    private static final int STATS_REFRESH_INTERVAL = 30000;
    private static final int STAT_LEFT_MARGIN = 34;
    private static final int STAT_TEXT_SIZE = 10;
    RelativeLayout mainParentlayout;
    private final SparseArray<ViewGroup> mUserViewList = new SparseArray<>(MAX_USER);
    private final List<Integer> mUidList = new ArrayList<>(MAX_USER);
    private StatsManager mStatsManager;
    private Handler mHandler;
    private int mStatMarginBottom, user_id;

    public VideoGridContainer(Context context) {
        super(context);
        init();
    }

    public VideoGridContainer(Context context, AttributeSet attrs) {
        super(context, attrs);
        init();
    }

    public VideoGridContainer(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init();
    }

    private void init() {
        setBackgroundResource(R.drawable.live_room_bg);
        mStatMarginBottom = getResources().getDimensionPixelSize(
                R.dimen.live_stat_margin_bottom);
        mHandler = new Handler(Looper.getMainLooper());
    }

    public void setMainParentLayout(RelativeLayout layout) {
        this.mainParentlayout = layout;
    }

    public void setStatsManager(StatsManager manager) {
        mStatsManager = manager;
    }

    public void addUserVideoSurface(int uid, SurfaceView surface, boolean isLocal) {
        Functions.printLog(Constants.tag, "addUserVideoSurface:" + uid);

        if (surface == null) {
            return;
        }

        int id = -1;
        if (isLocal) {
//            if (mUidList.contains(0)) {
//                mUidList.remove((Integer) 0);
//                mUserViewList.remove(0);
//            }
//
            if (mUidList.contains(uid)) {
                mUidList.remove((Integer) uid);
                mUserViewList.remove(uid);
            }

            if (mUidList.size() == MAX_USER) {
                mUidList.remove((Integer) uid);
                mUserViewList.remove(uid);
            }
            id = 0;
        } else {
            if (mUidList.contains(uid)) {
                mUidList.remove((Integer) uid);
                mUserViewList.remove(uid);
            }

            if (mUidList.size() < MAX_USER) {
                id = uid;
            }
        }

        if (id == 0) {
            mUidList.add(0, uid);
        } else mUidList.add(uid);

        if (id != -1) {
            mUserViewList.append(uid, createVideoView(surface));

            if (mStatsManager != null) {
                mStatsManager.addUserStats(uid, isLocal);
                if (mStatsManager.isEnabled()) {
                    mHandler.removeCallbacks(this);
                    mHandler.postDelayed(this, STATS_REFRESH_INTERVAL);
                }
            }

            requestGridLayout();
        }
    }


    private ViewGroup createVideoView(SurfaceView surface) {
        RelativeLayout layout = new RelativeLayout(getContext());

        layout.setId(surface.hashCode());

        LayoutParams videoLayoutParams =
                new LayoutParams(
                        ViewGroup.LayoutParams.MATCH_PARENT,
                        ViewGroup.LayoutParams.MATCH_PARENT);
        layout.addView(surface, videoLayoutParams);

        TextView text = new TextView(getContext());
        text.setId(layout.hashCode());
        LayoutParams textParams =
                new LayoutParams(
                        ViewGroup.LayoutParams.MATCH_PARENT,
                        ViewGroup.LayoutParams.WRAP_CONTENT);
        textParams.addRule(RelativeLayout.ALIGN_PARENT_BOTTOM, RelativeLayout.TRUE);
        textParams.bottomMargin = mStatMarginBottom;
        textParams.leftMargin = STAT_LEFT_MARGIN;
        text.setTextColor(Color.WHITE);
        text.setTextSize(STAT_TEXT_SIZE);

        layout.addView(text, textParams);
        return layout;
    }

    public void removeUserVideo(int uid, boolean isLocal) {
        if (isLocal && mUidList.contains(0)) {
            mUidList.remove((Integer) 0);
            mUserViewList.remove(0);
        } else if (mUidList.contains(uid)) {
            mUidList.remove((Integer) uid);
            mUserViewList.remove(uid);
        }

        mStatsManager.removeUserStats(uid);
        requestGridLayout();

        if (getChildCount() == 0) {
            mHandler.removeCallbacks(this);
        }
    }

    private void requestGridLayout() {
        removeAllViews();
        layout(mUidList.size());
    }

    private void layout(int size) {
        LayoutParams[] params = getParams(size);

        if (mainParentlayout != null) {
            if (size == 1) {
                LayoutParams params1 = new LayoutParams(
                        LayoutParams.MATCH_PARENT,
                        LayoutParams.MATCH_PARENT);
                params1.setMargins(0, 0
                        , 0, 0);
                params1.addRule(RelativeLayout.ALIGN_PARENT_TOP, RelativeLayout.TRUE);
                params1.addRule(RelativeLayout.ALIGN_PARENT_BOTTOM, RelativeLayout.TRUE);
                params1.addRule(RelativeLayout.ALIGN_PARENT_START, RelativeLayout.TRUE);
                params1.addRule(RelativeLayout.CENTER_VERTICAL, RelativeLayout.TRUE);
                mainParentlayout.setLayoutParams(params1);
            } else if (size == 2) {
                LayoutParams params1 = (LayoutParams) mainParentlayout.getLayoutParams();
                params1.setMargins(0, getResources().getDimensionPixelSize(R.dimen._80sdp)
                        , 0, getMeasuredWidth());
                mainParentlayout.setLayoutParams(params1);
            } else {
                LayoutParams params1 = (LayoutParams) mainParentlayout.getLayoutParams();
                params1.setMargins(0, getResources().getDimensionPixelSize(R.dimen._80sdp)
                        , 0, getResources().getDimensionPixelSize(R.dimen._80sdp));
                mainParentlayout.setLayoutParams(params1);
            }
        }

        for (int i = 0; i < size; i++) {
            if (mUidList.get(i) != null) {

                if (mUserViewList.get(mUidList.get(i)) != null && mUserViewList.get(mUidList.get(i)).getParent() != null) {
                    ((ViewGroup) mUserViewList.get(mUidList.get(i)).getParent()).removeView(mUserViewList.get(mUidList.get(i)));
                }

                try {
                    addView(mUserViewList.get(mUidList.get(i)), params[i]);
                } catch (Exception e) {
                }
            }
        }
    }

    private LayoutParams[] getParams(int size) {
        int width = getMeasuredWidth();
        int height = getMeasuredHeight();

        LayoutParams[] array =
                new LayoutParams[size];

        for (int i = 0; i < size; i++) {
            if (i == 0) {
                array[0] = new LayoutParams(
                        LayoutParams.MATCH_PARENT,
                        LayoutParams.MATCH_PARENT);
                array[0].setMargins(0, 0
                        , 0, 0);
                array[0].addRule(RelativeLayout.ALIGN_PARENT_TOP, RelativeLayout.TRUE);
                array[0].addRule(RelativeLayout.ALIGN_PARENT_BOTTOM, RelativeLayout.TRUE);
                array[0].addRule(RelativeLayout.ALIGN_PARENT_START, RelativeLayout.TRUE);
                array[0].addRule(RelativeLayout.CENTER_VERTICAL, RelativeLayout.TRUE);

            } else if (i == 1) {
                array[1] = new LayoutParams(width / 2, height);
                array[0].width = array[1].width;
                array[1].height = array[0].height;
                if (mainParentlayout == null) {
                    array[1].setMargins(0, getResources().getDimensionPixelSize(R.dimen._80sdp)
                            , 0, getResources().getDimensionPixelSize(R.dimen._80sdp));
                    array[0].setMargins(0, getResources().getDimensionPixelSize(R.dimen._80sdp)
                            , 0, getResources().getDimensionPixelSize(R.dimen._80sdp));
                }
                array[1].addRule(RelativeLayout.ALIGN_PARENT_END, RelativeLayout.TRUE);
                array[1].addRule(RelativeLayout.ALIGN_PARENT_TOP, RelativeLayout.TRUE);
                array[1].addRule(RelativeLayout.ALIGN_PARENT_BOTTOM, RelativeLayout.TRUE);
                array[1].addRule(RelativeLayout.CENTER_VERTICAL, RelativeLayout.TRUE);
            } else if (i == 2) {
                array[i] = new LayoutParams(width / 2, height / 2);
                array[i - 1].width = array[i].width;
                array[i].addRule(RelativeLayout.RIGHT_OF, mUserViewList.get(mUidList.get(i - 1)).getId());
                array[i].addRule(RelativeLayout.ALIGN_TOP, mUserViewList.get(mUidList.get(i - 1)).getId());
            } else if (i == 3) {
                array[i] = new LayoutParams(width / 2, height / 2);
                array[0].width = width / 2;
                array[1].addRule(RelativeLayout.BELOW, 0);
                array[1].addRule(RelativeLayout.ALIGN_PARENT_LEFT, 0);
                array[1].addRule(RelativeLayout.RIGHT_OF, mUserViewList.get(mUidList.get(0)).getId());
                array[1].addRule(RelativeLayout.ALIGN_PARENT_TOP, RelativeLayout.TRUE);
                array[2].addRule(RelativeLayout.ALIGN_PARENT_LEFT, RelativeLayout.TRUE);
                array[2].addRule(RelativeLayout.RIGHT_OF, 0);
                array[2].addRule(RelativeLayout.ALIGN_TOP, 0);
                array[2].addRule(RelativeLayout.BELOW, mUserViewList.get(mUidList.get(0)).getId());
                array[3].addRule(RelativeLayout.BELOW, mUserViewList.get(mUidList.get(1)).getId());
                array[3].addRule(RelativeLayout.RIGHT_OF, mUserViewList.get(mUidList.get(2)).getId());
            }
        }

        return array;
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        clearAllVideo();
    }

    private void clearAllVideo() {
        removeAllViews();
        mUserViewList.clear();
        mUidList.clear();
        mHandler.removeCallbacks(this);
    }

    @Override
    public void run() {
        if (mStatsManager != null && mStatsManager.isEnabled()) {
            int count = getChildCount();
            for (int i = 0; i < count; i++) {
                RelativeLayout layout = (RelativeLayout) getChildAt(i);
                TextView text = layout.findViewById(layout.hashCode());
                if (text != null) {
                    StatsData data = mStatsManager.getStatsData(mUidList.get(i));
                    String info = data != null ? data.toString() : null;
                    if (info != null) text.setText(info);
                }
            }

            mHandler.postDelayed(this, STATS_REFRESH_INTERVAL);
        }
    }


}
